/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.EnumSet;
import mage.abilities.Ability;
import mage.abilities.hint.Hint;
import mage.abilities.hint.HintUtils;
import mage.constants.CardType;
import mage.game.Game;
import mage.players.Player;

enum HappilyEverAfterCardTypeHint implements Hint
{
    instance;


    public String getText(Game game, Ability ability) {
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return null;
        }
        EnumSet<CardType> cardTypeSet = EnumSet.noneOf(CardType.class);
        game.getBattlefield().getAllActivePermanents(ability.getControllerId()).stream().map(permanent -> permanent.getCardType(game)).flatMap(Collection::stream).forEach(cardTypeSet::add);
        player.getGraveyard().getCards(game).stream().map(card -> card.getCardType(game)).flatMap(Collection::stream).forEach(cardTypeSet::add);
        if (cardTypeSet.isEmpty()) {
            return HintUtils.prepareText((String)"Card types on battlefield and in graveyard: None", null, (String)"ICON_BAD");
        }
        String message = cardTypeSet.stream().sorted().map(CardType::toString).reduce((a, b) -> a + ", " + b).get();
        return HintUtils.prepareText((String)("Card types on battlefield and in graveyard: " + cardTypeSet.size() + " (" + message + ")"), null, (String)(cardTypeSet.size() >= 6 ? "ICON_GOOD" : "ICON_BAD"));
    }

    public HappilyEverAfterCardTypeHint copy() {
        return instance;
    }
}

