/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.ArrayList;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.hint.Hint;
import mage.abilities.hint.HintUtils;
import mage.game.Game;
import mage.players.Player;

enum HappilyEverAfterColorHint implements Hint
{
    instance;


    public String getText(Game game, Ability ability) {
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return null;
        }
        ObjectColor color = new ObjectColor("");
        game.getBattlefield().getAllActivePermanents(ability.getControllerId()).stream().map(permanent -> permanent.getColor(game)).forEach(arg_0 -> ((ObjectColor)color).addColor(arg_0));
        if (color.isColorless()) {
            return HintUtils.prepareText((String)"Colors of permanents you control: 0 (None)", null, (String)"ICON_BAD");
        }
        ArrayList<String> colors = new ArrayList<String>();
        if (color.isWhite()) {
            colors.add("white");
        }
        if (color.isBlue()) {
            colors.add("blue");
        }
        if (color.isBlack()) {
            colors.add("black");
        }
        if (color.isRed()) {
            colors.add("red");
        }
        if (color.isGreen()) {
            colors.add("green");
        }
        String hintText = "Colors of permanents you control: " + color.getColorCount() + " (" + (String)colors.stream().reduce((a, b) -> a + ", " + b).get() + ")";
        if (color.getColors().size() == 5) {
            return HintUtils.prepareText((String)hintText, null, (String)"ICON_GOOD");
        }
        return HintUtils.prepareText((String)hintText, null, (String)"ICON_BAD");
    }

    public HappilyEverAfterColorHint copy() {
        return instance;
    }
}

