/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BlueManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HarbingerOfTheSeasEffect
extends ContinuousEffectImpl {
    private static final FilterLandPermanent filter = new FilterLandPermanent();

    HarbingerOfTheSeasEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Nonbasic lands are Islands";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
        this.dependencyTypes.add(DependencyType.BecomeIsland);
    }

    private HarbingerOfTheSeasEffect(HarbingerOfTheSeasEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public HarbingerOfTheSeasEffect copy() {
        return new HarbingerOfTheSeasEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent land : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    land.removeAllAbilities(source.getSourceId(), game);
                    land.removeAllSubTypes(game, SubTypeSet.NonBasicLandType);
                    land.addSubType(game, new SubType[]{SubType.ISLAND});
                    land.addAbility((Ability)new BlueManaAbility(), source.getSourceId(), game);
                }
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4;
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
    }
}

