/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class HarmonicProdigyEffect
extends ReplacementEffectImpl {
    HarmonicProdigyEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if an ability of a Shaman or another Wizard you control triggers, that ability triggers an additional time";
    }

    private HarmonicProdigyEffect(HarmonicProdigyEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public HarmonicProdigyEffect copy() {
        return new HarmonicProdigyEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && (permanent.hasSubtype(SubType.SHAMAN, game) || permanent.hasSubtype(SubType.WIZARD, game) && !permanent.getId().equals(source.getSourceId()));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }
}

