/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.h.HarperRecruiterTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class HarperRecruiterEffect
extends OneShotEffect {
    HarperRecruiterEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top four cards of your library. You may reveal a Cleric card, a Rogue card, a Warrior card, and/or a Wizard card from among them and put those cards into your hand. Put the rest on the bottom of your library in a random order";
    }

    private HarperRecruiterEffect(HarperRecruiterEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarperRecruiterEffect copy() {
        return new HarperRecruiterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 4));
        HarperRecruiterTarget target = new HarperRecruiterTarget();
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toHand = new CardsImpl((Collection)target.getTargets());
        player.revealCards(source, (Cards)toHand, game);
        player.moveCards((Cards)toHand, Zone.HAND, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

