/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.SubTypeAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class HarperRecruiterTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("a Cleric card, a Rogue card, a Warrior card, and/or a Wizard card");
    private static final SubTypeAssignment subTypeAssigner;

    HarperRecruiterTarget() {
        super(0, 4, filter);
    }

    private HarperRecruiterTarget(HarperRecruiterTarget target) {
        super((TargetCardInLibrary)target);
    }

    public HarperRecruiterTarget copy() {
        return new HarperRecruiterTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return subTypeAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{SubType.CLERIC.getPredicate(), SubType.ROGUE.getPredicate(), SubType.WARRIOR.getPredicate(), SubType.WIZARD.getPredicate()}));
        subTypeAssigner = new SubTypeAssignment(new SubType[]{SubType.CLERIC, SubType.ROGUE, SubType.WARRIOR, SubType.WIZARD});
    }
}

