/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.permanent.token.ThopterColorlessToken;
import mage.game.permanent.token.Token;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class HarriedDronesmithEffect
extends OneShotEffect {
    HarriedDronesmithEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 1/1 colorless Thopter artifact creature token with flying. It gains haste until end of turn. Sacrifice it at the beginning of your next end step";
    }

    private HarriedDronesmithEffect(HarriedDronesmithEffect effect) {
        super((OneShotEffect)effect);
    }

    public HarriedDronesmithEffect copy() {
        return new HarriedDronesmithEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ThopterColorlessToken token = new ThopterColorlessToken();
        token.putOntoBattlefield(1, game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new SacrificeTargetEffect().setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)).setText("sacrifice it"), TargetController.YOU), source);
        return true;
    }
}

