/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HateMirageEffect
extends OneShotEffect {
    HateMirageEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose up to two target creatures you don't control. For each of those creatures, create a token that's a copy of that creature. Those tokens gain haste. Exile them at the beginning of the next end step.";
    }

    private HateMirageEffect(HateMirageEffect effect) {
        super((OneShotEffect)effect);
    }

    public HateMirageEffect copy() {
        return new HateMirageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        source.getTargets().stream().map(Target::getTargets).flatMap(Collection::stream).forEach(uuid -> {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(uuid, game));
            effect.apply(game, source);
            effect.exileTokensCreatedAtNextEndStep(game, source);
        });
        return true;
    }
}

