/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.players.Player;
import mage.util.CardUtil;

class HauntingImitationEffect
extends OneShotEffect {
    HauntingImitationEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player reveals the top card of their library. For each creature card revealed this way, create a token that's a copy of that card, except it's 1/1, it's a Spirit in addition to its other types, and it has flying. If no creature cards were revealed this way, return {this} to its owner's hand";
    }

    private HauntingImitationEffect(HauntingImitationEffect effect) {
        super((OneShotEffect)effect);
    }

    public HauntingImitationEffect copy() {
        return new HauntingImitationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Card card;
            Player player = game.getPlayer(playerId);
            if (player == null || (card = player.getLibrary().getFromTop(game)) == null) continue;
            player.revealCards(source, (Cards)new CardsImpl((Collection)cards), game);
            if (!card.isCreature(game)) continue;
            cards.add(card);
        }
        if (cards.isEmpty()) {
            Player player = game.getPlayer(source.getControllerId());
            Card card = source.getSourceCardIfItStillExists(game);
            if (player != null && card != null) {
                player.moveCards(card, Zone.HAND, source, game);
            }
            return true;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, false, 1, false, false, null, 1, 1, true);
        effect.withAdditionalSubType(SubType.SPIRIT);
        for (Card card : cards.getCards(game)) {
            effect.setSavedPermanent((Permanent)new PermanentCard(CardUtil.getDefaultCardSideForBattlefield((Game)game, (Card)card), source.getControllerId(), game));
            effect.apply(game, source);
        }
        return true;
    }
}

