/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.ForetoldCondition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class HauntingVoyageEffect
extends OneShotEffect {
    HauntingVoyageEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return up to two creature cards of that type from your graveyard to the battlefield. If this spell was foretold, return all creature cards of that type from your graveyard to the battlefield instead";
    }

    private HauntingVoyageEffect(HauntingVoyageEffect effect) {
        super((OneShotEffect)effect);
    }

    public HauntingVoyageEffect copy() {
        return new HauntingVoyageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        SubType chosenSubType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        if (controller == null || chosenSubType == null) {
            return false;
        }
        FilterCard filter = new FilterCard(chosenSubType);
        if (ForetoldCondition.instance.apply(game, source)) {
            return controller.moveCards(controller.getGraveyard().getCards(filter, game), Zone.BATTLEFIELD, source, game);
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 2, filter, true);
        controller.chooseTarget(this.outcome, (Target)target, source, game);
        return controller.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
    }
}

