/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.h.HavengulLichEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;

class HavengulLichDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private UUID cardId;

    public HavengulLichDelayedTriggeredAbility(UUID cardId) {
        super((Effect)new HavengulLichEffect(cardId), Duration.EndOfTurn);
        this.cardId = cardId;
    }

    private HavengulLichDelayedTriggeredAbility(HavengulLichDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.cardId = ability.cardId;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getSourceId().equals(this.cardId);
    }

    public HavengulLichDelayedTriggeredAbility copy() {
        return new HavengulLichDelayedTriggeredAbility(this);
    }

    public String getRule() {
        return "When you cast that card this turn, {this} gains all activated abilities of that card until end of turn.";
    }
}

