/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Set;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.cards.h.HavengulMystery;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;

class HavengulMysteryLeavesAbility
extends TriggeredAbilityImpl {
    HavengulMysteryLeavesAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TransformSourceEffect());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private HavengulMysteryLeavesAbility(HavengulMysteryLeavesAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public HavengulMysteryLeavesAbility copy() {
        return new HavengulMysteryLeavesAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getFromZone() != Zone.BATTLEFIELD) {
            return false;
        }
        String key = HavengulMystery.makeKey((Ability)this, game);
        Set morSet = (Set)game.getState().getValue(key);
        return morSet != null && !morSet.isEmpty() && morSet.stream().anyMatch(mor -> mor.refersTo((MageObject)zEvent.getTarget(), game));
    }

    public String getRule() {
        return "When the creature put onto the battlefield with {this} leaves the battlefield, transform {this}.";
    }
}

