/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.triggers.BeginningOfCombatTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

public final class HazoretsFavor
extends CardImpl {
    public HazoretsFavor(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{R}");
        BoostTargetEffect effect = new BoostTargetEffect(2, 0, Duration.EndOfTurn);
        effect.setText("you may have target creature you control get +2/+0");
        BeginningOfCombatTriggeredAbility ability = new BeginningOfCombatTriggeredAbility((Effect)effect, true);
        effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
        effect.setText(" and gain haste until end of turn");
        ability.addEffect((Effect)effect);
        ability.addTarget((Target)new TargetControlledCreaturePermanent());
        ability.addEffect((Effect)new HazoretsFavorSacrificeEffect());
        this.addAbility((Ability)ability);
    }

    private HazoretsFavor(HazoretsFavor card) {
        super((CardImpl)card);
    }

    public HazoretsFavor copy() {
        return new HazoretsFavor(this);
    }

    private static class HazoretsFavorSacrificeEffect
    extends OneShotEffect {
        public HazoretsFavorSacrificeEffect() {
            super(Outcome.Sacrifice);
            this.staticText = "If you do, sacrifice it at the beginning of the next end step";
        }

        private HazoretsFavorSacrificeEffect(HazoretsFavorSacrificeEffect effect) {
            super((OneShotEffect)effect);
        }

        public HazoretsFavorSacrificeEffect copy() {
            return new HazoretsFavorSacrificeEffect(this);
        }

        public boolean apply(Game game, Ability source) {
            Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (creature != null) {
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("Sacrifice boosted " + creature.getName(), source.getControllerId());
                sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(creature, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
    }
}

