/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HeartOfBogardanEffect
extends OneShotEffect {
    HeartOfBogardanEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to target player or planeswalker and each creature that player or that planeswalker's controller controls, where X is twice the number of age counters on {this} minus 2";
    }

    private HeartOfBogardanEffect(HeartOfBogardanEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayerOrPlaneswalkerController(source.getFirstTarget());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player != null && sourcePermanent != null) {
            int damage = sourcePermanent.getCounters(game).getCount(CounterType.AGE) * 2 - 2;
            if (damage > 0) {
                player.damage(damage, source.getSourceId(), source, game);
                for (Permanent perm : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterCreaturePermanent(), player.getId(), game)) {
                    perm.damage(damage, source.getSourceId(), source, game, false, true);
                }
            }
            return true;
        }
        return false;
    }

    public HeartOfBogardanEffect copy() {
        return new HeartOfBogardanEffect(this);
    }
}

