/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.permanent.Permanent;

class HeartOfLightEffect
extends PreventionEffectImpl {
    HeartOfLightEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Prevent all damage that would be dealt to and dealt by enchanted creature";
    }

    private HeartOfLightEffect(HeartOfLightEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public HeartOfLightEffect copy() {
        return new HeartOfLightEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventDamageEvent preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage());
        if (!game.replaceEvent((GameEvent)preventEvent)) {
            int damage = event.getAmount();
            event.setAmount(0);
            game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent aura;
        if (super.applies(event, source, game) && event instanceof DamageEvent && (aura = game.getPermanent(source.getSourceId())) != null && aura.getAttachedTo() != null) {
            return event.getSourceId().equals(aura.getAttachedTo()) || event.getTargetId().equals(aura.getAttachedTo());
        }
        return false;
    }
}

