/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class HeartPiercerManticoreEffect
extends OneShotEffect {
    HeartPiercerManticoreEffect() {
        super(Outcome.Damage);
        this.staticText = "you may sacrifice another creature. When you do, {this} deals damage equal to that creature's power to any target";
    }

    private HeartPiercerManticoreEffect(HeartPiercerManticoreEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeartPiercerManticoreEffect copy() {
        return new HeartPiercerManticoreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE);
        if (!(cost.canPay(source, source, source.getControllerId(), game) && controller.chooseUse(this.outcome, "Sacrifice another creature?", source, game) && cost.pay(source, game, source, source.getControllerId(), false))) {
            return false;
        }
        int power = cost.getPermanents().stream().map(MageObject::getPower).mapToInt(MageInt::getValue).sum();
        ReflexiveTriggeredAbility trigger = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(power), false, "{this} deals damage equal to that creature's power to any target.");
        return true;
    }
}

