/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.combat.CantBeBlockedTargetEffect;
import mage.abilities.effects.common.continuous.BoostAllEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class HearthCharm
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature with power 2 or less");

    public HearthCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{R}");
        this.getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_CREATURE));
        Mode mode = new Mode((Effect)new BoostAllEffect(1, 0, Duration.EndOfTurn, (FilterCreaturePermanent)StaticFilters.FILTER_ATTACKING_CREATURES, false));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new CantBeBlockedTargetEffect());
        mode.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.getSpellAbility().addMode(mode);
    }

    private HearthCharm(HearthCharm card) {
        super((CardImpl)card);
    }

    public HearthCharm copy() {
        return new HearthCharm(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 3));
    }
}

