/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.cost.SpellCostReductionForEachSourceEffect;
import mage.abilities.effects.common.discard.DiscardHandControllerEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.AdventureCard;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AdventurePredicate;

public final class HearthElemental
extends AdventureCard {
    private static final FilterCard filter = new FilterCard("cards in your graveyard that are instant cards, sorcery cards, and/or have an Adventure");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public HearthElemental(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, new CardType[]{CardType.SORCERY}, "{5}{R}", "Stoke Genius", "{1}{R}");
        this.subtype.add((Object)SubType.ELEMENTAL);
        this.power = new MageInt(4);
        this.toughness = new MageInt(5);
        Ability ability = new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionForEachSourceEffect(1, xValue).setText("This spell costs {X} less to cast, where X is the number of cards in your graveyard that are instant cards, sorcery cards, and/or have an Adventure")).addHint(hint);
        this.addAbility(ability);
        this.getSpellCard().getSpellAbility().addEffect((Effect)new DiscardHandControllerEffect());
        this.getSpellCard().getSpellAbility().addEffect((Effect)new DrawCardSourceControllerEffect(2).concatBy(", then"));
        this.finalizeAdventure();
    }

    private HearthElemental(HearthElemental card) {
        super((AdventureCard)card);
    }

    public HearthElemental copy() {
        return new HearthElemental(this);
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate(), AdventurePredicate.instance}));
        xValue = new CardsInControllerGraveyardCount(filter);
        hint = new ValueHint("Number of Instant, Sorcery and/or Adventures in your graveyard", xValue);
    }
}

