/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class HeartlessConscriptionEffect
extends OneShotEffect {
    HeartlessConscriptionEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile all creatures. For each card exiled this way, you may play that card for as long as it remains exiled, and mana of any type can be spent to cast that spell.";
    }

    private HeartlessConscriptionEffect(HeartlessConscriptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeartlessConscriptionEffect copy() {
        return new HeartlessConscriptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), source, game).stream().forEach(arg_0 -> ((Cards)cards).add(arg_0));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfGame, (boolean)true);
        }
        return true;
    }
}

