/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HeatShimmerEffect
extends OneShotEffect {
    HeatShimmerEffect() {
        super(Outcome.Copy);
        this.staticText = "Create a token that's a copy of target creature, except it has haste and \"At the beginning of the end step, exile this permanent.\"";
    }

    private HeatShimmerEffect(HeatShimmerEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeatShimmerEffect copy() {
        return new HeatShimmerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && permanent != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId(), null, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
            ExileTargetEffect exileEffect = new ExileTargetEffect();
            exileEffect.setTargetPointer((TargetPointer)new FixedTarget((Permanent)effect.getAddedPermanents().get(0), game));
            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }
}

