/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HeavenSentEffect
extends OneShotEffect {
    HeavenSentEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if an opponent has 0 or less life, draw seven cards. Otherwise, exile {this} and you may cast it this turn.";
    }

    private HeavenSentEffect(HeavenSentEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeavenSentEffect copy() {
        return new HeavenSentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        boolean condition = game.getOpponents(player.getId()).stream().map(id -> game.getPlayer(id)).filter(Objects::nonNull).anyMatch(p -> p.getLife() <= 0);
        if (condition) {
            return new DrawCardSourceControllerEffect(7).apply(game, source);
        }
        Permanent heaven = source.getSourcePermanentIfItStillExists(game);
        if (heaven == null) {
            return false;
        }
        player.moveCardsToExile((Card)heaven, source, game, true, null, "");
        if (game.getState().getZone(heaven.getId()) == Zone.EXILED) {
            game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, false, true).setTargetPointer((TargetPointer)new FixedTarget(heaven, game)), source);
        }
        return true;
    }
}

