/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;

class HedonistsTrovePlayLandEffect
extends AsThoughEffectImpl {
    HedonistsTrovePlayLandEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "You may play lands from among cards exiled with {this}";
    }

    private HedonistsTrovePlayLandEffect(HedonistsTrovePlayLandEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public HedonistsTrovePlayLandEffect copy() {
        return new HedonistsTrovePlayLandEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card cardToCheck = game.getCard(objectId);
        if (cardToCheck == null || !cardToCheck.isLand(game) || !source.isControlledBy(affectedControllerId)) {
            return false;
        }
        UUID exileId = (UUID)game.getState().getValue(source.getSourceId().toString());
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        return exileZone != null && exileZone.contains((Object)cardToCheck.getMainCard().getId());
    }
}

