/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class HedonistsTroveWatcher
extends Watcher {
    private static final Set<MageObjectReference> emptySet = new HashSet<MageObjectReference>();
    private final Map<UUID, Set<MageObjectReference>> playerMap = new HashMap<UUID, Set<MageObjectReference>>();

    HedonistsTroveWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST || event.getApprovingObject() == null) {
            return;
        }
        this.playerMap.computeIfAbsent(event.getPlayerId(), x -> new HashSet()).add(event.getApprovingObject().getApprovingMageObjectReference());
        this.playerMap.get(event.getPlayerId()).removeIf(Objects::isNull);
    }

    boolean checkPlayer(UUID playerId, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        return permanent != null && this.playerMap.getOrDefault(playerId, emptySet).stream().noneMatch(mor -> mor.refersTo((MageObject)permanent, game));
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
    }
}

