/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class HedronFieldPuristsEffect
extends PreventionEffectImpl {
    HedronFieldPuristsEffect(int amount) {
        super(Duration.WhileOnBattlefield, amount, false, false);
        this.staticText = "If a source would deal damage to you or a creature you control, prevent " + amount + " of that damage";
    }

    private HedronFieldPuristsEffect(HedronFieldPuristsEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PLAYER && event.getTargetId().equals(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        if (event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public HedronFieldPuristsEffect copy() {
        return new HedronFieldPuristsEffect(this);
    }
}

