/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HeirloomBladeEffect
extends OneShotEffect {
    HeirloomBladeEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "reveal cards from the top of your library until you reveal a creature card that shares a creature type with it. Put that card into your hand and the rest on the bottom of your library in a random order";
    }

    private HeirloomBladeEffect(HeirloomBladeEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeirloomBladeEffect copy() {
        return new HeirloomBladeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent equipped;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent equipment = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && equipment != null && (equipped = (Permanent)this.getValue("attachedTo")) != null) {
            CardsImpl revealed = new CardsImpl();
            CardsImpl otherCards = new CardsImpl();
            for (Card card : controller.getLibrary().getCards(game)) {
                revealed.add(card);
                if (card != null && card.isCreature(game) && equipped.shareCreatureTypes(game, (MageObject)card)) {
                    controller.moveCardToHandWithInfo(card, source, game, true);
                    break;
                }
                otherCards.add(card);
            }
            controller.revealCards(equipment.getIdName(), (Cards)revealed, game);
            controller.putCardsOnBottomOfLibrary((Cards)otherCards, game, source, false);
            return true;
        }
        return false;
    }
}

