/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class HellcarverDemonEffect
extends OneShotEffect {
    HellcarverDemonEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top six cards of your library. You may cast any number of spells from among cards exiled this way without paying their mana costs";
    }

    private HellcarverDemonEffect(HellcarverDemonEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl(controller.getLibrary().getTopCards(game, 6)), (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }

    public HellcarverDemonEffect copy() {
        return new HellcarverDemonEffect(this);
    }
}

