/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeSourceControllerEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.SpellsCastWatcher;

class HellishRebukeTriggeredAbility
extends TriggeredAbilityImpl {
    private final String sourceName;
    private final UUID casterId;

    HellishRebukeTriggeredAbility(Ability source, Game game) {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeSourceEffect());
        this.addEffect((Effect)new LoseLifeSourceControllerEffect(2));
        this.sourceName = HellishRebukeTriggeredAbility.getSourceName(source, game);
        this.casterId = HellishRebukeTriggeredAbility.getCasterId(source, game);
    }

    private HellishRebukeTriggeredAbility(HellishRebukeTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.sourceName = ability.sourceName;
        this.casterId = ability.casterId;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getSourceId().equals(this.getSourceId()) && event.getPlayerId().equals(this.casterId);
    }

    public HellishRebukeTriggeredAbility copy() {
        return new HellishRebukeTriggeredAbility(this);
    }

    public String getRule() {
        return "When this permanent deals damage to the player who cast " + this.sourceName + ", sacrifice this permanent. You lose 2 life.";
    }

    private static String getSourceName(Ability source, Game game) {
        MageObject object = source.getSourceObject(game);
        return object != null ? object.getName() : "Hellish Rebuke";
    }

    private static UUID getCasterId(Ability source, Game game) {
        SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
        return watcher.getCasterId(source, game);
    }
}

