/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.cards.h.HellkiteCourserReturnEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class HellkiteCourserEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("commander you own from the command zone");

    HellkiteCourserEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a commander you own from the command zone onto the battlefield. It gains haste. Return it to the command zone at the beginning of the next end step";
    }

    private HellkiteCourserEffect(HellkiteCourserEffect effect) {
        super((OneShotEffect)effect);
    }

    public HellkiteCourserEffect copy() {
        return new HellkiteCourserEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCard target = new TargetCard(0, 1, Zone.COMMAND, filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new HellkiteCourserReturnEffect(permanent, game)), source);
        return true;
    }

    static {
        filter.add((Predicate)CommanderPredicate.instance);
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
    }
}

