/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.KaldraToken;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class HelmOfKaldraEffect
extends OneShotEffect {
    private static final FilterPermanent filterHelm = new FilterControlledPermanent(SubType.EQUIPMENT);
    private static final FilterPermanent filterSword = new FilterControlledPermanent(SubType.EQUIPMENT);
    private static final FilterPermanent filterShield = new FilterControlledPermanent(SubType.EQUIPMENT);

    HelmOfKaldraEffect() {
        super(Outcome.Benefit);
        this.staticText = "if you control Equipment named Helm of Kaldra, Sword of Kaldra, and Shield of Kaldra, create Kaldra, a legendary 4/4 colorless Avatar creature token. Attach those Equipment to it";
    }

    private HelmOfKaldraEffect(HelmOfKaldraEffect effect) {
        super((OneShotEffect)effect);
    }

    public HelmOfKaldraEffect copy() {
        return new HelmOfKaldraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        if (!(game.getBattlefield().contains(filterHelm, source, game, 1) && game.getBattlefield().contains(filterSword, source, game, 1) && game.getBattlefield().contains(filterShield, source, game, 1))) {
            return false;
        }
        KaldraToken token = new KaldraToken();
        token.putOntoBattlefield(1, game, source);
        Set permanents = token.getLastAddedTokenIds().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        switch (permanents.size()) {
            case 0: {
                return true;
            }
            case 1: {
                permanent = (Permanent)RandomUtil.randomFromCollection(permanents);
                break;
            }
            default: {
                FilterPermanent filter = new FilterPermanent();
                filter.add((Predicate)new PermanentReferenceInCollectionPredicate(permanents, game));
                TargetPermanent target = new TargetPermanent(filter);
                target.withNotTarget(true);
                target.withChooseHint("to equip");
                Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.choose(this.outcome, (Target)target, source, game));
                permanent = game.getPermanent(target.getFirstTarget());
            }
        }
        if (permanent == null) {
            return true;
        }
        HashSet equipments = new HashSet();
        equipments.addAll(game.getBattlefield().getActivePermanents(filterHelm, source.getControllerId(), source, game));
        equipments.addAll(game.getBattlefield().getActivePermanents(filterSword, source.getControllerId(), source, game));
        equipments.addAll(game.getBattlefield().getActivePermanents(filterShield, source.getControllerId(), source, game));
        for (Permanent equipment : equipments) {
            permanent.addAttachment(equipment.getId(), source, game);
        }
        return true;
    }

    static {
        filterHelm.add((Predicate)new NamePredicate("Helm of Kaldra"));
        filterSword.add((Predicate)new NamePredicate("Sword of Kaldra"));
        filterShield.add((Predicate)new NamePredicate("Shield of Kaldra"));
    }
}

