/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HeraldOfLeshracCumulativeCost
extends CostImpl {
    private static final FilterPermanent filter = new FilterLandPermanent("land you don't control");

    HeraldOfLeshracCumulativeCost() {
        this.text = "Gain control of a land you don't control";
    }

    private HeraldOfLeshracCumulativeCost(HeraldOfLeshracCumulativeCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        TargetPermanent target = new TargetPermanent(filter);
        if (target.choose(Outcome.GainControl, controllerId, source.getSourceId(), source, game)) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame);
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
            game.addEffect((ContinuousEffect)effect, ability);
            game.processAction();
            this.paid = true;
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return game.getBattlefield().contains(filter, controllerId, source, game, 1);
    }

    public HeraldOfLeshracCumulativeCost copy() {
        return new HeraldOfLeshracCumulativeCost(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
    }
}

