/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HeraldOfLeshracLeavesEffect
extends OneShotEffect {
    HeraldOfLeshracLeavesEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player gains control of each land they own that you control";
    }

    private HeraldOfLeshracLeavesEffect(HeraldOfLeshracLeavesEffect effect) {
        super((OneShotEffect)effect);
    }

    public HeraldOfLeshracLeavesEffect copy() {
        return new HeraldOfLeshracLeavesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (playerId.equals(source.getControllerId())) continue;
            FilterLandPermanent filter = new FilterLandPermanent();
            filter.add((Predicate)new OwnerIdPredicate(playerId));
            filter.add((Predicate)new ControllerIdPredicate(source.getControllerId()));
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame, playerId);
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                game.addEffect((ContinuousEffect)effect, source);
            }
        }
        return true;
    }
}

