/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class HeraldOfWarCostReductionEffect
extends CostModificationEffectImpl {
    HeraldOfWarCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Angel spells and Human spells you cast cost {1} less to cast for each +1/+1 counter on {this}";
    }

    private HeraldOfWarCostReductionEffect(HeraldOfWarCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int amount;
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (sourcePermanent != null && (amount = sourcePermanent.getCounters(game).getCount(CounterType.P1P1)) > 0) {
            CardUtil.adjustCost((SpellAbility)spellAbility, (int)amount);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card sourceCard;
        return abilityToModify instanceof SpellAbility && (sourceCard = game.getCard(abilityToModify.getSourceId())) != null && abilityToModify.isControlledBy(source.getControllerId()) && (sourceCard.hasSubtype(SubType.ANGEL, game) || sourceCard.hasSubtype(SubType.HUMAN, game));
    }

    public HeraldOfWarCostReductionEffect copy() {
        return new HeraldOfWarCostReductionEffect(this);
    }
}

