/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HeraldicBannerEffect
extends ContinuousEffectImpl {
    HeraldicBannerEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "Creatures you control of the chosen color get +1/+0";
    }

    private HeraldicBannerEffect(HeraldicBannerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public HeraldicBannerEffect copy() {
        return new HeraldicBannerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        ObjectColor color = (ObjectColor)game.getState().getValue(permanent.getId() + "_color");
        if (color == null) {
            return false;
        }
        for (Permanent perm : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            if (!perm.getColor(game).contains(color)) continue;
            perm.addPower(1);
        }
        return true;
    }
}

