/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.h.HeroOfBretagardTriggeredAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.counters.CounterType;

public final class HeroOfBretagard
extends CardImpl {
    private static final Condition FIVE_OR_MORE_COUNTERS = new SourceHasCounterCondition(CounterType.P1P1, 5);
    private static final Condition TEN_OR_MORE_COUNTERS = new SourceHasCounterCondition(CounterType.P1P1, 10);

    public HeroOfBretagard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{W}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.WARRIOR);
        this.power = new MageInt(1);
        this.toughness = new MageInt(1);
        this.addAbility((Ability)new HeroOfBretagardTriggeredAbility());
        SimpleStaticAbility fiveCountersAbility = new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.WhileOnBattlefield), FIVE_OR_MORE_COUNTERS, "As long as {this} has five or more counters on it, it has flying"));
        fiveCountersAbility.addEffect((Effect)new ConditionalContinuousEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.WhileOnBattlefield, new SubType[]{SubType.ANGEL}), FIVE_OR_MORE_COUNTERS, "and is an Angel in addition to its other types"));
        this.addAbility((Ability)fiveCountersAbility);
        SimpleStaticAbility tenCountersAbility = new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)IndestructibleAbility.getInstance(), Duration.WhileOnBattlefield), TEN_OR_MORE_COUNTERS, "As long as {this} has ten or more counters on it, it has indestructible"));
        tenCountersAbility.addEffect((Effect)new ConditionalContinuousEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.WhileOnBattlefield, true, new SubType[]{SubType.GOD}), TEN_OR_MORE_COUNTERS, "and is a God in addition to its other types"));
        this.addAbility((Ability)tenCountersAbility);
    }

    private HeroOfBretagard(HeroOfBretagard card) {
        super((CardImpl)card);
    }

    public HeroOfBretagard copy() {
        return new HeroOfBretagard(this);
    }
}

