/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class HexParasiteEffect
extends OneShotEffect {
    HexParasiteEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "Remove up to X counters from target permanent. For each counter removed this way, {this} gets +1/+0 until end of turn";
    }

    private HexParasiteEffect(HexParasiteEffect effect) {
        super((OneShotEffect)effect);
    }

    public HexParasiteEffect copy() {
        return new HexParasiteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String[] counterNames;
        TargetPermanent target = (TargetPermanent)source.getTargets().get(0);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent == null || controller == null) {
            return false;
        }
        int toRemove = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (toRemove == 0) {
            return true;
        }
        int removed = 0;
        for (String counterName : counterNames = permanent.getCounters(game).keySet().toArray(new String[0])) {
            if (controller.chooseUse(Outcome.Neutral, "Remove " + counterName + " counters?", source, game)) {
                if (((Counter)permanent.getCounters(game).get((Object)counterName)).getCount() == 1 || toRemove - removed == 1) {
                    permanent.removeCounters(counterName, 1, source, game);
                    ++removed;
                } else {
                    int amount = controller.getAmount(1, Math.min(((Counter)permanent.getCounters(game).get((Object)counterName)).getCount(), toRemove - removed), "How many?", source, game);
                    if (amount > 0) {
                        removed += amount;
                        permanent.removeCounters(counterName, amount, source, game);
                    }
                }
            }
            if (removed >= toRemove) break;
        }
        if (removed > 0) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(removed, 0, Duration.EndOfTurn), source);
        }
        return true;
    }
}

