/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.StateTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsEnchantmentCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;

class HiddenPredatorsStateTriggeredAbility
extends StateTriggeredAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public HiddenPredatorsStateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BecomesCreatureSourceEffect((Token)new CreatureToken(4, 4, "4/4 Beast creature", new SubType[]{SubType.BEAST}), null, Duration.Custom));
        this.withInterveningIf((Condition)SourceIsEnchantmentCondition.instance);
        this.withRuleTextReplacement(true);
        this.setTriggerPhrase("When an opponent controls a creature with power 4 or greater, ");
    }

    private HiddenPredatorsStateTriggeredAbility(HiddenPredatorsStateTriggeredAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public HiddenPredatorsStateTriggeredAbility copy() {
        return new HiddenPredatorsStateTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return !game.getBattlefield().getActivePermanents((FilterPermanent)filter, game.getControllerId(this.getSourceId()), game).isEmpty();
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
    }
}

