/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;

class HiddenRetreatEffect
extends PreventionEffectImpl {
    HiddenRetreatEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, false);
        this.staticText = "Prevent all damage that would be dealt by target instant or sorcery spell this turn.";
    }

    private HiddenRetreatEffect(HiddenRetreatEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public HiddenRetreatEffect copy() {
        return new HiddenRetreatEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event instanceof DamageEvent && event.getAmount() > 0 && game.getObject(source.getFirstTarget()) != null && game.getObject(event.getSourceId()) != null && game.getObject(source.getFirstTarget()).equals(game.getObject(event.getSourceId())) && game.getObject(source.getFirstTarget()).isInstantOrSorcery(game);
    }
}

