/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Cards;
import mage.constants.PutCards;
import mage.game.Game;
import mage.players.Player;

class HideInPlainSightEffect
extends LookLibraryAndPickControllerEffect {
    HideInPlainSightEffect() {
        super(5, 2, PutCards.BATTLEFIELD, PutCards.BOTTOM_RANDOM);
    }

    private HideInPlainSightEffect(HideInPlainSightEffect effect) {
        super((LookLibraryAndPickControllerEffect)effect);
    }

    public HideInPlainSightEffect copy() {
        return new HideInPlainSightEffect(this);
    }

    public boolean actionWithPickedCards(Game game, Ability source, Player player, Cards pickedCards, Cards otherCards) {
        Set cards = pickedCards.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        boolean result = !ManifestEffect.doManifestCards((Game)game, (Ability)source, (Player)player, cards, (boolean)true).isEmpty();
        return result |= this.putLookedCards.moveCards(player, otherCards, source, game);
    }

    public String getText(Mode mode) {
        return "Look at the top five cards of your library, cloak two of them, and put the rest on the bottom of your library in a random order";
    }
}

