/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class HidetsuguDevouringChaosEffect
extends OneShotEffect {
    HidetsuguDevouringChaosEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. You may play that card this turn. When you exile a nonland card this way, {this} deals damage equal to the exiled card's mana value to any target";
    }

    private HidetsuguDevouringChaosEffect(HidetsuguDevouringChaosEffect effect) {
        super((OneShotEffect)effect);
    }

    public HidetsuguDevouringChaosEffect copy() {
        return new HidetsuguDevouringChaosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)card, (TargetController)TargetController.YOU, (Duration)Duration.EndOfTurn, (boolean)false, (boolean)false, (boolean)false);
        if (card.isLand(game)) {
            return true;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(card.getManaValue()), false);
        ability.addTarget((Target)new TargetAnyTarget());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

