/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Mode;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.Target;

class HinderingLightPredicate
implements ObjectSourcePlayerPredicate<StackObject> {
    HinderingLightPredicate() {
    }

    public boolean apply(ObjectSourcePlayer<StackObject> input, Game game) {
        UUID controllerId = input.getPlayerId();
        if (controllerId == null) {
            return false;
        }
        for (UUID modeId : ((StackObject)input.getObject()).getStackAbility().getModes().getSelectedModes()) {
            Mode mode = ((StackObject)input.getObject()).getStackAbility().getModes().get((Object)modeId);
            for (Target target : mode.getTargets()) {
                for (UUID targetId : target.getTargets()) {
                    if (controllerId.equals(targetId)) {
                        return true;
                    }
                    Permanent permanent = game.getPermanent(targetId);
                    if (permanent == null || !controllerId.equals(permanent.getControllerId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return "spell that targets you or a permanent you control";
    }
}

