/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.ShroudAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HisokasGuardGainAbilityTargetEffect
extends ContinuousEffectImpl {
    protected Ability ability;

    public HisokasGuardGainAbilityTargetEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Target creature you control other than {this} has shroud for as long as {this} remains tapped";
        this.ability = ShroudAbility.getInstance();
    }

    private HisokasGuardGainAbilityTargetEffect(HisokasGuardGainAbilityTargetEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.ability = effect.ability.copy();
    }

    public HisokasGuardGainAbilityTargetEffect copy() {
        return new HisokasGuardGainAbilityTargetEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Permanent guardedCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent hisokasGuard = game.getPermanent(source.getSourceId());
        if (guardedCreature != null && hisokasGuard != null) {
            hisokasGuard.addConnectedCard("HisokasGuard", guardedCreature.getId());
        }
    }

    public boolean apply(Game game, Ability source) {
        Permanent hisokasGuard = game.getPermanent(source.getSourceId());
        if (hisokasGuard != null && !hisokasGuard.getConnectedCards("HisokasGuard").isEmpty()) {
            Permanent guardedCreature = game.getPermanent((UUID)hisokasGuard.getConnectedCards("HisokasGuard").get(0));
            if (guardedCreature != null && hisokasGuard.isTapped()) {
                guardedCreature.addAbility(this.ability, source.getSourceId(), game);
                return true;
            }
            if (!hisokasGuard.isTapped()) {
                hisokasGuard.clearConnectedCards("HisokasGuard");
            }
        }
        return false;
    }
}

