/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class HitEffect
extends OneShotEffect {
    HitEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Target player sacrifices an artifact or creature. {this} deals damage to that player equal to that permanent's mana value";
    }

    private HitEffect(HitEffect effect) {
        super((OneShotEffect)effect);
    }

    public HitEffect copy() {
        return new HitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetSacrifice target;
        Player targetPlayer = game.getPlayer(source.getTargets().getFirstTarget());
        if (targetPlayer != null && (target = new TargetSacrifice(StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_CREATURE)).canChoose(targetPlayer.getId(), source, game)) {
            targetPlayer.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                permanent.sacrifice(source, game);
                int damage = permanent.getManaValue();
                if (damage > 0) {
                    targetPlayer.damage(damage, source.getSourceId(), source, game);
                }
            }
        }
        return true;
    }
}

