/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.players.PlayerList;

class HiveMindEffect
extends OneShotEffect {
    HiveMindEffect() {
        super(Outcome.Benefit);
        this.staticText = "each other player copies that spell. Each of those players may choose new targets for their copy";
    }

    private HiveMindEffect(HiveMindEffect effect) {
        super((OneShotEffect)effect);
    }

    public HiveMindEffect copy() {
        return new HiveMindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        Player player = game.getPlayer(source.getControllerId());
        if (spell != null && player != null) {
            PlayerList range = game.getState().getPlayersInRange(player.getId(), game);
            for (UUID playerId : game.getState().getPlayerList(spell.getControllerId())) {
                if (playerId.equals(spell.getControllerId()) || !range.contains((Object)playerId)) continue;
                spell.createCopyOnStack(game, source, playerId, true);
            }
            return true;
        }
        return false;
    }
}

