/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HoardSmelterEffect
extends ContinuousEffectImpl {
    private int costValue = 0;

    HoardSmelterEffect() {
        super(Duration.EndOfTurn, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "{this} gets +X/+0 until end of turn, where X is that artifact's mana value";
    }

    private HoardSmelterEffect(HoardSmelterEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.costValue = effect.costValue;
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getSourceId());
        if (target != null) {
            target.addPower(this.costValue);
            return true;
        }
        return false;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Card targeted = game.getCard(source.getFirstTarget());
        if (targeted != null) {
            this.costValue = targeted.getManaValue();
        }
    }

    public HoardSmelterEffect copy() {
        return new HoardSmelterEffect(this);
    }
}

