/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class HoardingBroodlordEffect
extends OneShotEffect {
    HoardingBroodlordEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a card, exile it face down, then shuffle. For as long as that card remains exiled, you may play it";
    }

    private HoardingBroodlordEffect(HoardingBroodlordEffect effect) {
        super((OneShotEffect)effect);
    }

    public HoardingBroodlordEffect copy() {
        return new HoardingBroodlordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary();
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getFirstTarget(), game);
        player.shuffleLibrary(source, game);
        if (card != null) {
            player.moveCards(card, Zone.EXILED, source, game);
            card.setFaceDown(true, game);
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)false);
        }
        return true;
    }
}

