/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class HofriGhostforgeReturnEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    HofriGhostforgeReturnEffect(Card card, Game game) {
        super(Outcome.Benefit);
        this.mor = new MageObjectReference((MageObject)card, game);
        this.staticText = "return the exiled card to its owner's graveyard";
    }

    private HofriGhostforgeReturnEffect(HofriGhostforgeReturnEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public HofriGhostforgeReturnEffect copy() {
        return new HofriGhostforgeReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = this.mor.getCard(game);
        return player != null && card != null && player.moveCards(card, Zone.GRAVEYARD, source, game);
    }
}

