/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HoldForRansomSacrificeEffect
extends OneShotEffect {
    HoldForRansomSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "{this}'s controller sacrifices it and draws a card";
    }

    private HoldForRansomSacrificeEffect(HoldForRansomSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public HoldForRansomSacrificeEffect copy() {
        return new HoldForRansomSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent aura = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (aura == null) {
            return false;
        }
        Player auraController = game.getPlayer(aura.getControllerId());
        aura.sacrifice(source, game);
        if (auraController != null) {
            auraController.drawCards(1, source, game);
        }
        return true;
    }
}

