/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;

class HolyAvengerEffect
extends OneShotEffect {
    HolyAvengerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may put an Aura card from your hand onto the battlefield attached to it";
    }

    private HolyAvengerEffect(HolyAvengerEffect effect) {
        super((OneShotEffect)effect);
    }

    public HolyAvengerEffect copy() {
        return new HolyAvengerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (player == null || sourcePermanent == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(sourcePermanent.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        FilterCard filter = new FilterCard("an Aura than can enchant " + permanent.getName());
        filter.add((Predicate)SubType.AURA.getPredicate());
        filter.add((Predicate)new AuraCardCanAttachToPermanentId(permanent.getId()));
        TargetCardInHand target = new TargetCardInHand(0, 1, filter);
        player.choose(Outcome.PutCardInPlay, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        game.getState().setValue("attachTo:" + card.getId(), (Object)permanent);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        if (!permanent.addAttachment(card.getId(), source, game)) {
            return false;
        }
        game.informPlayers(player.getLogName() + " put " + card.getLogName() + " on the battlefield attached to " + permanent.getLogName() + '.');
        return true;
    }
}

