/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.GameState;
import mage.players.Player;

class HonorTheFallenEffect
extends OneShotEffect {
    HonorTheFallenEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all creature cards from all graveyards. You gain 1 life for each card exiled this way";
    }

    private HonorTheFallenEffect(HonorTheFallenEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.addAllCards((Collection)player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        }
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        int count = cards.stream().map(arg_0 -> ((GameState)game.getState()).getZone(arg_0)).map(arg_0 -> Zone.EXILED.equals(arg_0)).mapToInt(x -> x != false ? 1 : 0).sum();
        controller.gainLife(count, game, source);
        return true;
    }

    public HonorTheFallenEffect copy() {
        return new HonorTheFallenEffect(this);
    }
}

