/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.common.PreventNextDamageFromChosenSourceToTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class HonorablePassageEffect
extends PreventNextDamageFromChosenSourceToTargetEffect {
    HonorablePassageEffect() {
        super(Duration.EndOfTurn);
        this.staticText = "The next time a source of your choice would deal damage to any target this turn, prevent that damage. If damage from a red source is prevented this way, {this} deals that much damage to the source's controller";
    }

    private HonorablePassageEffect(HonorablePassageEffect effect) {
        super((PreventNextDamageFromChosenSourceToTargetEffect)effect);
    }

    public HonorablePassageEffect copy() {
        return new HonorablePassageEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int damage = event.getAmount();
        PreventionEffectData preventEffectData = this.preventDamageAction(event, source, game);
        if (preventEffectData.getPreventedDamage() > 0) {
            Player sourceController;
            UUID sourceControllerId;
            MageObject sourceObject = game.getObject(event.getSourceId());
            if (sourceObject != null && sourceObject.getColor(game).isRed() && (sourceControllerId = game.getControllerId(event.getSourceId())) != null && (sourceController = game.getPlayer(sourceControllerId)) != null) {
                sourceController.damage(damage, source.getSourceId(), source, game);
            }
            this.used = true;
        }
        return false;
    }
}

